#include <iostream>
#include <ctime>

#include "clock.h"
#include "piece.h"
#include "defs.h"
#include "log.h"
#include "searcher.h"


using namespace std;

const uint maxtime = 0xffffff;

cClock::cClock()
{
     running = false;
     watchstart = watchstop = 0;
}

void cClock::start()
{
     watchstart = (uint(clock()));
     running = true;
}
void cClock::stop()
{
     watchstop = (uint(clock()));
     running = false;
}

uint cClock::time_elapsed()
{
     if(running)
     {
       return ((uint(clock())) - watchstart);
     }
     else
     {
       return (watchstop - watchstart);
     }
}

void cClock::print_time_elapsed()
{
     uint elapsed;
     if(running)
     {
       elapsed = ((uint(clock())) - watchstart)/1000;
     }
     else
     {
       elapsed = (watchstop - watchstart);
     }
     cout<<"\n elapsed: "<<elapsed<<"s";
}

void cClock::setmovetime(const uint time, const uint col)
{
    ASS(colourgood(col));
    movetime[col] = time;
}


void cClock::setsessiontime(const uint time, const uint col)
{
    ASS(colourgood(col));
    sessiontime[col] = time;
}

void cClock::setinc(const uint incr, const uint col)
{
    ASS(colourgood(col));
    inc[col] = incr;
}

void cClock::setmovestogo(const uint moves, const uint col)
{
    ASS(colourgood(col));
    ASS(moves<maxgamelength);
    movestogo[col] = moves;
}

void cClock::setdepth(const uint d)
{
    depth = d;
    if(depth>=maxply) depth=maxply;
}

void cClock::settimepermove(const uint t)
{
    timepermove = t;
}
void cClock::setstarttime(const uint t)
{
    starttime = t;
}
void cClock::setstoptime(const uint t)
{
    stoptime = t;
}

void cClock::resettimeparam(const uint col)
{
      movetime[col] = 0;
      sessiontime[col] = 0;
	  inc[col] = 0;
      movestogo[col] = 0;
	  depth = maxply;
	  timepermove = 0;
	  starttime = 0;
	  stoptime = 0;
	  alloctime = 0;

      modetimepermove = false;
      modemovestogo = false;

      movespersession = 0;

      depthlimit = false;
}

bool cClock::timeup()
{
    if( (uint(clock())) > stoptime)
    {
        stop();
        return true;
    }
    return false;
}

void cClock::allocatemovetime(const uint col, const uint status)
{
   // cout<<"\nmode = "<<status<<endl;
    if (status & smPONDER || status & smINFINITE )
    {
        alloctime = maxtime;
        depth = maxply;
        if(logger.islog())
        logger.file << "allocating ininfinte time control\n";
        return;
    }
    else if(depthlimit==true)
    {
        alloctime = maxtime;
        if(logger.islog())
        logger.file << "allocating maxtime due to depth limited game\n";
        return;
    }
    else if (timepermove!=0)
    {
        alloctime = timepermove - 200;
        if(logger.islog())
        logger.file << "allocating time per move control\n";
        return;
    }
    else
    {
       if (movestogo[col]!=0)//given moves to next time control
       {
          alloctime =  ( (movetime[col] + (inc[col]*movestogo[col]) )/movestogo[col]+1)-500;
          if(logger.islog())
          logger.file << "allocating moves to go time control\n";
          return;
       }
       else
       {
         alloctime = movetime[col]/30 + inc[col];
         if(logger.islog())
         logger.file << "allocating general time left control\n";
         return;
       }
    }
    if(logger.islog())  logger.file << "time allocation error";
}

void cClock::startsearchtimer(const uint side, const uint mode, const bool ponderhit)
{
   allocatemovetime(side,mode);
   if(logger.islog())logger.file << "allocated "<<alloctime<<"ms for the move\n";

   start();
   starttime = watchstart;
   stoptime = starttime+alloctime;

   ASS(stoptime  > starttime);

   if(depth>maxply) depth=maxply;

   if(logger.islog()) logger.file << "starting timer starttime "<<starttime/1000<<" movetime "<<alloctime/1000<<" stoptime "<<stoptime/1000<<" depth "<<depth;
}

void cClock::adjustforphit()
{
    ASS(alloctime>0);
    ASS(pondertime>0);

    cout<<"adjusting time for phit ";
    uint timetoadd = alloctime*125/100;
    cout<<" alloctime = "<<alloctime;
    cout<<" 25% more "<<timetoadd-alloctime<<endl;
    cout<<"had been pondering for "<<pondertime;

    timetoadd-=alloctime;
    if(alloctime <= pondertime) alloctime = timetoadd-1;
    else alloctime-=pondertime;
    if(alloctime<timetoadd) alloctime = timetoadd;
    cout<<" new alloctime "<<alloctime<<endl;
    fflush(stdout);
}
